<?php
/** ****************************************************************************
 * 
 *          #               # # # #      
 *         # #             #        #   
 *        #   #           #         #    
 *       #     #         #         #     
 *      #       #       #        #
 *     # # # # # #     # # # # #
 *    #           #   #        ____ ____ __   __  _   (с)
 *   #             # #          /  /_   /_\   / \/ |
 *  #               #          /  /___ /   \ /     |
 * 
 * @author Alexandr V PODUSOV <avpodusov@yandex.ru>
 * @copyright (c) 2022, Alexandr Podusov
 **************************************************************************** */

if (!defined('BOOTSTRAP')) { die('Access denied'); }

use Tygh\Registry;
use Tygh\Settings;

if ($mode == 'view_changes') {   
    $changes_tree = Tygh::$app['view']->getTemplateVars('changes_tree');    
    $changes_tree['files_list'] = avp_recursive_filearray_rebuilding($changes_tree); 
    fn_compress_files('/changes_files.zip', $changes_tree['files_list'], DIR_ROOT);
    $hash = md5_file(DIR_ROOT . "/changes_files.zip");
    if (strcmp($hash, Registry::get('addons.avp_adv_tools_view_chng.hash')) !== 0) {
        $newname = Registry::get("config.dir.files") . $hash . ".zip";
        $newpath = Registry::get("config.dir.files") . Registry::get('addons.avp_adv_tools_view_chng.hash') . ".zip";
        if(file_exists($newpath)) { unlink($newpath); }
        copy(DIR_ROOT . "/changes_files.zip",$newname);
        Settings::instance()->updateValue('hash', $hash, 'avp_adv_tools_view_chng');
        Registry::set('addons.avp_adv_tools_view_chng.hash', $hash);
        Settings::instance()->updateValue('size', filesize($newname), 'avp_adv_tools_view_chng');
        Registry::set('addons.avp_adv_tools_view_chng.size', filesize($newname));
        Settings::instance()->updateValue('datetime', TIME, 'avp_adv_tools_view_chng');
        Registry::set('addons.avp_adv_tools_view_chng.datetime', TIME);
    }
    unlink(DIR_ROOT . "/changes_files.zip");
    
    $file_data = [
        'hash' => Registry::get('addons.avp_adv_tools_view_chng.hash'),
        'size' => Registry::get('addons.avp_adv_tools_view_chng.size'),
        'datetime' => Registry::get('addons.avp_adv_tools_view_chng.datetime')
    ]; 
    
    Tygh::$app['view']->assign('changes_tree', $changes_tree);    
    Tygh::$app['view']->assign('file_data', $file_data);    
    
    $path_hooks =  "/design/backend/templates/addons/*/hooks/*/*.override.tpl";
    $path_file_hooks =  "/design/backend/templates/addons/*/overrides/*";
    $scan_dirs = fn_get_dir_contents(DIR_ROOT."/design/backend/templates/addons", true, false, '', '', false, array());
    
    if (Registry::get('addons.avp_adv_tools_view_chng.override_only_active_addons') == "Y") {
        $scan_dirs = db_get_fields("SELECT addon FROM ?:addons WHERE status = 'A'");
    }
    
    $override_hooks = [];
    foreach ($scan_dirs as $addon_dir) {
        $_o = [];
        if (file_exists(DIR_ROOT."/design/backend/templates/addons/".$addon_dir."/hooks")) {
            $__o = fn_get_dir_contents(DIR_ROOT."/design/backend/templates/addons/".$addon_dir."/hooks", true, false, '', '', false, array());
            foreach ($__o as $___o) {
                $hook_files = fn_get_dir_contents(DIR_ROOT."/design/backend/templates/addons/".$addon_dir."/hooks/".$___o, false, true, '', '', false, array());
                foreach ($hook_files as $hook_file) {
                    if (strpos($hook_file, ".override.tpl") !== false) {
                        $override_hooks[] = "/design/backend/templates/addons/".$addon_dir."/hooks/".$___o."/".$hook_file;
                    }
                }
            }
        }
    }
    foreach ($scan_dirs as $addon_dir) {
        $_o = [];
        if (file_exists(DIR_ROOT."/design/themes/responsive/templates/addons/".$addon_dir."/hooks")) {
            $__o = fn_get_dir_contents(DIR_ROOT."/design/themes/responsive/templates/addons/".$addon_dir."/hooks", true, false, '', '', false, array());
            foreach ($__o as $___o) {
                $hook_files = fn_get_dir_contents(DIR_ROOT."/design/themes/responsive/templates/addons/".$addon_dir."/hooks/".$___o, false, true, '', '', false, array());
                foreach ($hook_files as $hook_file) {
                    if (strpos($hook_file, ".override.tpl") !== false) {
                        $override_hooks[] = "/design/themes/responsive/templates/addons/".$addon_dir."/hooks/".$___o."/".$hook_file;
                    }
                }
            }
        }
    }
    $override_template_hooks = [];
    foreach ($scan_dirs as $addon_dir) {
        $_o = [];
        if (file_exists(DIR_ROOT."/design/backend/templates/addons/".$addon_dir."/overrides")) {
            $_o = fn_get_dir_contents(DIR_ROOT."/design/backend/templates/addons/".$addon_dir."/overrides", false, true, '', '', true, array());
        }
        foreach ($_o as $___o) {
            $override_template_hooks[] = "/design/backend/templates/addons/".$addon_dir."/overrides/".$___o;
        }
    }
    foreach ($scan_dirs as $addon_dir) {
        $_o = [];
        if (file_exists(DIR_ROOT."/design/themes/responsive/templates/addons/".$addon_dir."/overrides")) {
            $_o = fn_get_dir_contents(DIR_ROOT."/design/themes/responsive/templates/addons/".$addon_dir."/overrides", false, true, '', '', true, array());
        }
        foreach ($_o as $___o) {
            $override_template_hooks[] = "/design/themes/responsive/templates/addons/".$addon_dir."/overrides/".$___o;
        }
    }
    Tygh::$app['view']->assign('override_hooks', $override_hooks);    
    Tygh::$app['view']->assign('override_template_hooks', $override_template_hooks);
}

if ($mode == "download_view_changes") {
    header("Pragma: public");
    header("Expires: 0");
    header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
    header("Cache-Control: public"); 
    header("Content-Description: File Transfer");
    header("Content-Type: application/zip");
    $filename_old = Registry::get("config.dir.files") . Registry::get('addons.avp_adv_tools_view_chng.hash') . ".zip";
    $len = filesize($filename_old);
    $filename_new = "change_files_" . str_replace(".", "_", PRODUCT_VERSION) . "_" . date("Y_m_d") . ".zip";
    $header="Content-Disposition: attachment; filename=\"".basename($filename_new)."\";";
    header($header);
    header("Content-Transfer-Encoding: binary");
    header("Content-Length: ".$len);
    @readfile($filename_old);
    exit;
}


/**
 * Рекурсивное преобразование многоуровнего массива файлов в одномерный.
 * @param array $branch
 * @param string $path
 * @return array
 */
function avp_recursive_filearray_rebuilding ($branch, $path = "") 
{   
    $__cluster = array();        
    foreach ($branch as $key => $value) {                
        if ($value['type'] == 'dir') {
            $__cluster = array_merge($__cluster, avp_recursive_filearray_rebuilding($value['content'], $value['name'] == '/' ? $value['name'] : $path . $value['name'] . "/"));
        } else {
            if ($value['action'] == 'changed') { $__cluster['changes_files'.$path.$value['name']] = $path . $value['name']; }
        }
    }    
    return $__cluster;
}


