{* *****************************************************************************
 * @author Alexandr V PODUSOV <avpodusov@yandex.ru>
 * @copyright (c) 2022, Alexandr Podusov
 *
 * Шаблон подменяет собой стандартный шаблон tools/view_changes.tpl
 **************************************************************************** *}
{if $language_direction == "rtl"}
    {$direction = "right"}
{else}
    {$direction = "left"}
{/if}
{* AVP CUT }
{capture name="diff_legend"}
    <div class="diff-legend">
        {if $check_types.A}
            <span class="label snapshot-added">{__("file_changes_detector.added")}</span>
        {/if}
        {if $check_types.C}
            <span class="label snapshot-changed">{__("file_changes_detector.changed")}</span>
        {/if}
        {if $check_types.D}
            <span class="label snapshot-deleted">{__("file_changes_detector.deleted")}</span>
        {/if}
    </div>
{/capture}
{ /AVP CUT *}
{capture name="mainbox"}
    <div class="items-container multi-level">
        {if $changes_tree}

            <div class="alert alert-block">
                <p>{__("modified_core_files_found", ['[product]' => $smarty.const.PRODUCT_NAME])}</p>
            </div>
{* AVP CUT }            
            {include file="views/tools/components/changes_tree.tpl"
                parent_id=0
                show_all=true
                expand_all=true
                direction=$direction
            }
{ /AVP CUT *}            
{* AVP PASTE *} 
<h3>Измененные файлы</h3>
<pre>{foreach from=$changes_tree.files_list item=file key=item_id}
{$file}
{/foreach}</pre>
{if $file_data.hash}    
<a href="{"tools.download_view_changes"|fn_url}" target="_blank">{__("avp_adv_tools_download_array")}</a>
<b>{__("version")}: {$smarty.const.PRODUCT_VERSION}</b> ({$file_data.size|formatfilesize nofilter}, {$file_data.datetime|date_format:"`$settings.Appearance.date_format`, `$settings.Appearance.time_format`"})
{else}<b>No file!</b>{/if}
{* /AVP PASTE *}
        {else}
            <p class="no-items">{__("no_modified_core_files_found")}</p>
        {/if}
    </div>

    {if $db_diff}
        {include file="common/subheader.tpl" title=__("database_structure_changes")}
        <pre style="height: 400px; overflow-y: scroll" class="diff-container">{$db_diff nofilter}</pre>
    {/if}

    {** include fileuploader **}
    {*include file="common/file_browser.tpl"*}
    {** /include fileuploader **}

    <form action="{""|fn_url}" method="post" name="data_compare_form" enctype="multipart/form-data" class="form-horizontal form-edit">
        {if $config.tweaks.show_database_changes}

            {include file="common/subheader.tpl" title=__("database_data_changes")}

            <div class="control-group">
                <label class="control-label" for="name_db" >{__("db_name")}</label>
                <div class="controls">
                    <input type="text" name="compare_data[db_name]" id="name_db" value="" class="span4" />
                </div>
            </div>
            <div class="control-group">
                <label class="control-label" for="type_base_file">{__("file")}</label>
                <div class="controls">
                    {if $compare_data.file_path}
                        <b>{$compare_data.file_path}</b> ({$compare_data.file_size|formatfilesize nofilter})
                    {/if}
                {include file="common/fileuploader.tpl" var_name="base_file"}
                </div>
            </div>
        {/if}

        {capture name="buttons"}
            {if $config.tweaks.show_database_changes}
                {include file="buttons/button.tpl" but_text=__("compare") but_role="action" but_target_form="data_compare_form" but_name="dispatch[tools.view_changes]" but_meta="cm-submit"}
            {/if}

            {if !$dist_filename}
                <a class="btn btn-primary" href="{"tools.create_snapshot?redirect_url={$config.current_url|escape:url}"|fn_url}">{__("scan_for_modified_core_files")}</a>
            {/if}
        {/capture}
    </form>

    {if $db_d_diff}
        <pre style="height: 300px; overflow-y: scroll" class="diff-container">{$db_d_diff nofilter}</pre>
    {/if}

    {if $changes_tree || $db_diff || $db_d_diff}
        {$smarty.capture.diff_legend nofilter}
    {/if}

    {capture name="sidebar"}
        <div class="sidebar-row">
            <h6>{__("last_scan_time")}</h6>
            <p>
                {if $dist_filename}
                    <span class="muted">{__("file_changes_detector.snapshot_not_found", ['[dist_filename]' => $dist_filename]) nofilter}</span>
                {else}
                    {if $creation_time}<span class="muted">{$creation_time|date_format:"`$settings.Appearance.date_format`, `$settings.Appearance.time_format`"}</span>{/if}
                {/if}
            </p>
            <hr />
        </div>
    {/capture}
{* AVP CUT } 
    {$changes_tree_keys=$changes_tree|array_keys}
    <script>
        Tygh.$(document).ready(function(){ldelim}
            Tygh.$('#on_changes_{$changes_tree_keys.0}').click();
        {rdelim}
        );
    </script>
{ /AVP CUT *}   
<h3>Оверрайды хуков шаблонов</h3>
<pre>
{foreach from=$override_hooks item=file key=item_id}
{$file}
{/foreach}    
</pre>
<h3>Оверрайды шаблонов</h3>
<pre>
{foreach from=$override_template_hooks item=file key=item_id}
{$file}
{/foreach}    
</pre>
{/capture}

{include file="common/mainbox.tpl" title=__("file_changes_detector") content=$smarty.capture.mainbox buttons=$smarty.capture.buttons sidebar=$smarty.capture.sidebar}
